/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WToolBar;

import LumiSoft.UI.Controls.ImageList;
import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WMenu.WContextMenu;
import LumiSoft.UI.Controls.WMenu.WContextMenuListener;
import LumiSoft.UI.Controls.WToolBar.WToolBarItem;
import LumiSoft.UI.Controls.WToolBar.WToolBarItems;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WToolBar
extends JPanel
implements MouseListener,
MouseMotionListener,
WContextMenuListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private ImageList m_pImageList = null;
    private WToolBarItems m_pItems = null;
    private WToolBarItem m_pHotItem = null;
    private WContextMenu m_pActiveMenu = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WToolBar() {
        this.m_ViewStyle = new ViewStyle();
        this.m_pItems = new WToolBarItems(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.Calculate((Graphics2D)g);
        int i = 0;
        while (i < this.m_pItems.size()) {
            WToolBarItem item = (WToolBarItem)this.m_pItems.get(i);
            boolean hot = item.getBounds().contains(this.m_MousePos);
            this.DrawItem((Graphics2D)g, item, hot, this.m_MouseModifiers == 16);
            ++i;
        }
    }

    private void DrawItem(Graphics2D g, WToolBarItem item, boolean hot, boolean pressed) {
        if (!item.getSeparator()) {
            if (item.getMenu() != null && item.getMenu() == this.m_pActiveMenu) {
                g.setColor(this.m_ViewStyle.getButtonHotColor());
                g.fill(item.getBounds());
                g.setColor(this.m_ViewStyle.getBorderColor());
                g.draw(item.getBounds());
            } else if (hot) {
                if (pressed) {
                    g.setColor(this.m_ViewStyle.getButtonPressedColor());
                    g.fill(item.getBounds());
                } else {
                    g.setColor(this.m_ViewStyle.getButtonHotColor());
                    g.fill(item.getBounds());
                }
                g.setColor(this.m_ViewStyle.getBorderHotColor());
                g.drawRect(item.getBounds().x, item.getBounds().y, item.getBounds().width - 1, item.getBounds().height - 2);
                if (item.getMenu() != null) {
                    g.drawLine((int)item.getBounds().getMaxX() - 13, 1, (int)item.getBounds().getMaxX() - 13, item.getBounds().height);
                }
            } else {
                g.setColor(this.m_ViewStyle.getControlBackColor());
                g.fill(item.getBounds());
            }
            if (this.getImageList() != null && item.getImageIndex() > -1 && item.getImageIndex() < this.getImageList().getCount()) {
                Image image = this.getImageList().get(item.getImageIndex());
                g.drawImage(image, item.getBounds().x + 3, item.getBounds().y + 2, 16, 16, this);
            }
            if (item.getMenu() != null) {
                g.setColor(Color.BLACK);
                Paint.DrawTriangle(g, new Rectangle((int)item.getBounds().getMaxX() - 10, 10, 7, 4), 2);
            }
        } else {
            g.setColor(this.m_ViewStyle.getControlBackColor());
            g.fill(item.getBounds());
            g.setColor(this.m_ViewStyle.getBorderColor());
            g.drawLine(item.getBounds().x + 2, 2, item.getBounds().x + 2, item.getBounds().height - 4);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this.m_pHotItem != null && !this.m_pHotItem.getSeparator()) {
            if (this.m_pActiveMenu != null) {
                this.m_pActiveMenu.Hide();
                this.m_pActiveMenu = null;
            }
            if (this.m_pHotItem.getMenu() != null) {
                this.m_pActiveMenu = this.m_pHotItem.getMenu();
                this.m_pActiveMenu.addContextMenuListener(this);
                this.m_pActiveMenu.Show(this.getLocationOnScreen().x + this.m_pHotItem.getBounds().x, this.getLocationOnScreen().y + this.getHeight());
            }
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, true, true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_pHotItem != null && !this.m_pHotItem.getSeparator()) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, this.m_pHotItem.getBounds().contains(this.m_MousePos), this.m_MouseModifiers == 16);
        }
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        if (this.m_pActiveMenu == null && this.m_pHotItem != null && this.getGraphics() != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, false);
            this.m_pHotItem = null;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        WToolBarItem inMouseItem = this.getInMouseItem();
        if (inMouseItem != this.m_pHotItem) {
            if (this.m_pActiveMenu != null) {
                this.m_pActiveMenu.Hide();
                this.m_pActiveMenu = null;
            }
            if (this.m_pHotItem != null) {
                this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, false);
            }
            if (inMouseItem != null && !inMouseItem.getSeparator()) {
                this.DrawItem((Graphics2D)this.getGraphics(), inMouseItem, true, this.m_MouseModifiers == 16);
            }
            this.m_pHotItem = inMouseItem;
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void ContextMenuClosed() {
        if (this.m_pActiveMenu != null) {
            this.m_pActiveMenu.removeContextMenuListener(this);
        }
        this.m_pActiveMenu = null;
        if (this.m_pHotItem != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, false);
        }
        this.m_pHotItem = null;
    }

    private void Calculate(Graphics2D g) {
        int x = 1;
        int i = 0;
        while (i < this.m_pItems.size()) {
            WToolBarItem item = (WToolBarItem)this.m_pItems.get(i);
            if (item.getSeparator()) {
                item.setBounds(new Rectangle(x, 1, 6, this.getHeight()));
                x += 6;
            } else if (item.getMenu() != null) {
                item.setBounds(new Rectangle(x, 1, 35, this.getHeight()));
                x += 34;
            } else {
                item.setBounds(new Rectangle(x, 1, 22, this.getHeight()));
                x += 22;
            }
            ++x;
            ++i;
        }
    }

    private WToolBarItem getInMouseItem() {
        int i = 0;
        while (i < this.m_pItems.size()) {
            WToolBarItem item = (WToolBarItem)this.m_pItems.get(i);
            if (item.getBounds() != null && item.getBounds().contains(this.m_MousePos)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public ImageList getImageList() {
        return this.m_pImageList;
    }

    public void setImageList(ImageList value) {
        if (value != null) {
            this.m_pImageList = value;
        }
    }

    public WToolBarItems getItems() {
        return this.m_pItems;
    }

    protected void fireToolbarItemPressed(WToolBarItem item) {
    }
}

