/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WMenu;

import LumiSoft.UI.Controls.ImageList;
import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WMenu.WContextMenu;
import LumiSoft.UI.Controls.WMenu.WMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class WPopup
extends JWindow
implements MouseListener,
MouseMotionListener,
HierarchyBoundsListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private WContextMenu m_pOwner = null;
    private Component m_pParent = null;
    private ArrayList m_pItems = null;
    private WMenuItem m_pHotItem = null;
    private WContextMenu m_pActiveSubMenu = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WPopup(WContextMenu owner, Component parent, ArrayList menuItems, ImageList imageList) {
        super(SwingUtilities.getWindowAncestor(parent));
        this.m_pOwner = owner;
        this.m_pParent = parent;
        this.m_pParent.addHierarchyBoundsListener(this);
        this.m_pItems = menuItems;
        this.m_ViewStyle = new ViewStyle();
        this.setFocusable(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paint(Graphics g) {
        g.setColor(Color.WHITE);
        ((Graphics2D)g).fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        g.setColor(ViewStyle.GetColorFromRgb(220, 212, 198));
        ((Graphics2D)g).fill(new Rectangle(0, 2, 24, this.getHeight() - 4));
        int y = 2;
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            if (item.getSeparator()) {
                item.setBounds(new Rectangle(1, y, this.getWidth() - 1, 4));
                y += 4;
            } else {
                item.setBounds(new Rectangle(1, y, this.getWidth() - 1, 22));
                y += 22;
            }
            boolean hot = item.getBounds().contains(this.m_MousePos) || item == this.m_pHotItem && this.m_pActiveSubMenu != null;
            this.DrawItem((Graphics2D)g, item, hot);
            ++i;
        }
        g.setColor(this.m_ViewStyle.getBorderColor());
        ((Graphics2D)g).draw(new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1));
    }

    private void DrawItem(Graphics2D g, WMenuItem item, boolean hot) {
        if (hot) {
            g.setColor(this.m_ViewStyle.getButtonHotColor());
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(item.getBounds().x, item.getBounds().y, item.getBounds().width - 2, item.getBounds().height);
        if (item.getSeparator()) {
            g.setColor(ViewStyle.GetColorFromRgb(220, 212, 198));
            g.fill(new Rectangle(item.getBounds().x, item.getBounds().y, 23, item.getBounds().height));
            g.setColor(this.m_ViewStyle.getBorderColor());
            g.drawLine(28, item.getBounds().y + 1, (int)item.getBounds().getMaxX(), item.getBounds().y + 1);
        } else {
            g.setColor(Color.BLACK);
            Paint.DrawText(g, this.getFont(), item.getText(), item.getTextRect(), 2);
            if (!hot) {
                g.setColor(ViewStyle.GetColorFromRgb(220, 212, 198));
                g.fill(new Rectangle(item.getBounds().x, item.getBounds().y, 23, item.getBounds().height));
            }
            if (this.m_pOwner.getImageList() != null && item.getImageIndex() > -1 && item.getImageIndex() < this.m_pOwner.getImageList().getCount()) {
                Image image = this.m_pOwner.getImageList().get(item.getImageIndex());
                g.drawImage(image, item.getBounds().x + 3, item.getBounds().y + 2, 16, 16, this);
            }
            if (item.getSubMenu() != null) {
                g.setColor(Color.BLACK);
                int y = item.getBounds().y + (item.getBounds().height - 7) / 2;
                Paint.DrawTriangle(g, new Rectangle((int)item.getBounds().getMaxX() - 9, y, 4, 7), 4);
            }
            if (hot) {
                g.setColor(Color.BLACK);
                g.draw(new Rectangle(item.getBounds().x + 2, item.getBounds().y, item.getBounds().width - 5, item.getBounds().height - 1));
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.m_pHotItem != null && !this.m_pHotItem.getSeparator() && this.m_pHotItem.getSubMenu() == null) {
            this.setVisible(false);
            WContextMenu menu = this.m_pOwner.m_pParentMenu;
            while (menu != null) {
                menu.Hide();
                menu = menu.m_pParentMenu;
            }
            this.OnMenuItemSelected(this.m_pHotItem);
            this.m_pParent.removeHierarchyBoundsListener(this);
            this.Hide();
        }
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        if (this.m_pActiveSubMenu == null && this.m_pHotItem != null && this.getGraphics() != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false);
            this.m_pHotItem = null;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        WMenuItem inMouseItem = this.getInMouseItem();
        if (inMouseItem != this.m_pHotItem) {
            if (this.m_pHotItem != null) {
                this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false);
            }
            if (inMouseItem != null && !inMouseItem.getSeparator()) {
                this.DrawItem((Graphics2D)this.getGraphics(), inMouseItem, true);
            }
            this.m_pHotItem = inMouseItem;
            if (this.m_pActiveSubMenu != null) {
                this.m_pActiveSubMenu.Hide();
                this.m_pActiveSubMenu = null;
            }
            if (this.m_pHotItem != null && this.m_pHotItem.getSubMenu() != null) {
                this.m_pActiveSubMenu = this.m_pHotItem.getSubMenu();
                this.m_pHotItem.getSubMenu().m_pParentMenu = this.m_pOwner;
                this.m_pActiveSubMenu.Show(this.getLocationOnScreen().x + this.getWidth(), this.getLocationOnScreen().y);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void ancestorMoved(HierarchyEvent e) {
        this.m_pParent.removeHierarchyBoundsListener(this);
        this.hide();
    }

    public void ancestorResized(HierarchyEvent e) {
        this.m_pParent.removeHierarchyBoundsListener(this);
        this.hide();
    }

    public void Show(int screenX, int screenY) {
        this.setSize(0, 0);
        this.setLocation(screenX, screenY);
        this.setVisible(true);
        Graphics g = this.getGraphics();
        this.CalculateSize((Graphics2D)g);
    }

    public void Hide() {
        if (this.m_pActiveSubMenu != null) {
            this.m_pActiveSubMenu.Hide();
            this.m_pActiveSubMenu = null;
        }
        this.m_pOwner.fireMenuClosed();
        this.setVisible(false);
        this.dispose();
    }

    private void CalculateSize(Graphics2D g) {
        int height = 0;
        int maxWidth = 0;
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            if (!item.getSeparator()) {
                int width = Paint.CalcTextWidth(g, this.getFont(), item.getText());
                if (width > maxWidth) {
                    maxWidth = width;
                }
                height += 22;
            } else {
                height += 4;
            }
            ++i;
        }
        this.setSize(new Dimension(maxWidth += 45, (height += 4) + this.getInsets().bottom));
    }

    private WMenuItem getInMouseItem() {
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            if (item.getBounds() != null && item.getBounds().contains(this.m_MousePos)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void OnMenuItemSelected(WMenuItem item) {
    }
}

