/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls.WMenu;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import LumiSoft.UI.Controls.WMenu.WContextMenu;
import LumiSoft.UI.Controls.WMenu.WContextMenuListener;
import LumiSoft.UI.Controls.WMenu.WMenuItem;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class WMenuBar
extends JPanel
implements FocusListener,
MouseListener,
MouseMotionListener,
WContextMenuListener {
    private boolean m_UseStaticViewStyle = true;
    private ViewStyle m_ViewStyle = null;
    private ArrayList m_pItems = null;
    private WMenuItem m_pHotItem = null;
    private WContextMenu m_pActiveSubMenu = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;

    public WMenuBar() {
        this.m_ViewStyle = new ViewStyle();
        this.m_pItems = new ArrayList();
        this.setFocusable(true);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.Calculate((Graphics2D)g);
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            boolean hot = item.getBounds().contains(this.m_MousePos);
            this.DrawItem((Graphics2D)g, item, hot, hot && this.hasFocus() || item.getSubMenu() == this.m_pActiveSubMenu);
            ++i;
        }
    }

    private void DrawItem(Graphics2D g, WMenuItem item, boolean hot, boolean focused) {
        if (focused) {
            g.setColor(this.m_ViewStyle.getBorderColor());
            g.fill(item.getBounds());
            g.setColor(this.m_ViewStyle.getBorderColor());
            g.drawRect(item.getBounds().x, item.getBounds().y, item.getBounds().width - 1, item.getBounds().height - 1);
        } else if (hot) {
            g.setColor(this.m_ViewStyle.getButtonHotColor());
            g.fill(item.getBounds());
            g.setColor(this.m_ViewStyle.getBorderHotColor());
            g.drawRect(item.getBounds().x, item.getBounds().y, item.getBounds().width - 1, item.getBounds().height - 1);
        } else {
            g.setColor(this.m_ViewStyle.getButtonColor());
            g.fill(item.getBounds());
        }
        g.setColor(Color.BLACK);
        Paint.DrawText(g, this.getFont(), item.getText(), item.getBounds(), 1);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.m_pHotItem != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, this.m_pHotItem.getBounds().contains(this.m_MousePos), this.m_pHotItem.getSubMenu() == this.m_pActiveSubMenu);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.hasFocus()) {
            this.grabFocus();
            if (this.m_pHotItem != null && this.m_pHotItem.getSubMenu() != null) {
                this.m_pActiveSubMenu = this.m_pHotItem.getSubMenu();
                this.m_pActiveSubMenu.addContextMenuListener(this);
                this.m_pActiveSubMenu.Show(this.getLocationOnScreen().x + this.m_pHotItem.getBounds().x, this.getLocationOnScreen().y + this.getHeight());
                this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, true, true);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        if (this.m_pHotItem != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, this.m_pHotItem.getSubMenu() == this.m_pActiveSubMenu);
            if (this.m_pHotItem.getSubMenu() != this.m_pActiveSubMenu) {
                this.m_pHotItem = null;
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        WMenuItem inMouseItem = this.getInMouseItem();
        if (inMouseItem != this.m_pHotItem) {
            if (this.m_pActiveSubMenu != null) {
                this.m_pActiveSubMenu.Hide();
                this.m_pActiveSubMenu = null;
            }
            if (this.m_pHotItem != null) {
                this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, false);
            }
            if (inMouseItem != null && !inMouseItem.getSeparator()) {
                this.DrawItem((Graphics2D)this.getGraphics(), inMouseItem, true, this.hasFocus());
            }
            this.m_pHotItem = inMouseItem;
            if (this.hasFocus() && this.m_pHotItem != null && this.m_pHotItem.getSubMenu() != null) {
                this.m_pActiveSubMenu = this.m_pHotItem.getSubMenu();
                this.m_pActiveSubMenu.addContextMenuListener(this);
                this.m_pActiveSubMenu.Show(this.getLocationOnScreen().x + this.m_pHotItem.getBounds().x, this.getLocationOnScreen().y + this.getHeight());
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void ContextMenuClosed() {
        if (this.m_pActiveSubMenu != null) {
            this.m_pActiveSubMenu.removeContextMenuListener(this);
        }
        this.m_pActiveSubMenu = null;
        if (this.m_pHotItem != null) {
            this.DrawItem((Graphics2D)this.getGraphics(), this.m_pHotItem, false, false);
        }
        this.m_pHotItem = null;
    }

    public void Add(String text) {
        WMenuItem item = new WMenuItem();
        item.setText(text);
        this.m_pItems.add(item);
    }

    public WMenuItem get(int value) {
        return (WMenuItem)this.m_pItems.get(value);
    }

    private void Calculate(Graphics2D g) {
        int width = 0;
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            int itemWidth = Paint.CalcTextWidth(g, this.getFont(), item.getText()) + 10;
            item.setBounds(new Rectangle(width, 1, itemWidth + 1, this.getHeight() - 1));
            width = itemWidth;
            ++i;
        }
    }

    private WMenuItem getInMouseItem() {
        int i = 0;
        while (i < this.m_pItems.size()) {
            WMenuItem item = (WMenuItem)this.m_pItems.get(i);
            if (item.getBounds() != null && item.getBounds().contains(this.m_MousePos)) {
                return item;
            }
            ++i;
        }
        return null;
    }
}

