/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Controls;

import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.Utils;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;

public class WButtonEdit
extends JPanel
implements MouseListener,
MouseMotionListener {
    private boolean m_UseStaticViewStyle = true;
    protected ViewStyle m_ViewStyle = null;
    private int m_ButtonAlign = 3;
    private int m_ButtonWidth = 18;
    private Image m_pButtonImage = null;
    private Point m_MousePos = new Point(-1, -1);
    private int m_MouseModifiers = 0;
    private String m_HittedObject = "";
    private Dimension m_Size = new Dimension(0, 0);

    public WButtonEdit() {
        this.m_ViewStyle = new ViewStyle();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics g) {
        if (this.m_Size != this.getSize()) {
            this.m_Size = this.getSize();
            this.SizeChanged();
        }
        this.Draw((Graphics2D)g);
    }

    protected void SizeChanged() {
    }

    private Rectangle getTriangleRect(Rectangle buttonRect) {
        return new Rectangle(buttonRect.x + 4, buttonRect.y + 7, buttonRect.width - 7, buttonRect.height - 12);
    }

    private void Draw(Graphics2D g) {
        Rectangle clientRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        boolean hot = Utils.ContainsFocus(this) || clientRect.contains(this.m_MousePos);
        g.setColor(this.m_ViewStyle.getButtonColor());
        g.fill(clientRect);
        boolean buttonHot = this.getButtonRect().contains(this.m_MousePos);
        g.setColor(this.m_ViewStyle.GetButtonColor(buttonHot, this.m_MouseModifiers == 1024));
        g.fill(this.getButtonRect());
        g.setColor(Color.BLACK);
        if (this.m_pButtonImage == null) {
            Paint.DrawTriangle(g, this.getTriangleRect(this.getButtonRect()), 2);
        } else {
            g.drawImage(this.m_pButtonImage, this.getButtonRect().x, this.getButtonRect().y, this.getButtonRect().width, this.getButtonRect().height, this);
        }
        g.setColor(this.m_ViewStyle.GetBorderColor(hot));
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        if (this.m_ButtonAlign == 2) {
            g.drawLine((int)this.getButtonRect().getMaxX(), 0, (int)this.getButtonRect().getMaxX(), this.getHeight());
        } else {
            g.drawLine(this.getButtonRect().x, 0, this.getButtonRect().x, this.getHeight());
        }
    }

    public void mousePressed(MouseEvent e) {
        this.m_MouseModifiers = e.getModifiersEx();
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.m_MouseModifiers = 0;
        if (this.getButtonRect().contains(this.m_MousePos)) {
            this.OnButtonClicked();
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent e) {
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.m_MousePos = new Point(-1, -1);
        this.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.m_MousePos = e.getPoint();
        String hittedObject = "";
        if (this.getButtonRect().contains(this.m_MousePos)) {
            hittedObject = "Button";
        }
        if (this.m_HittedObject != hittedObject) {
            this.m_HittedObject = hittedObject;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Rectangle getButtonRect() {
        if (this.m_ButtonAlign == 3) {
            return new Rectangle(this.getWidth() - this.m_ButtonWidth, 1, this.m_ButtonWidth - 1, this.getHeight() - 2);
        }
        return new Rectangle(1, 1, this.m_ButtonWidth - 1, this.getHeight() - 2);
    }

    protected Rectangle getEditRect() {
        if (this.m_ButtonAlign == 3) {
            return new Rectangle(2, 1, this.getWidth() - this.getButtonRect().width - 4, this.getHeight() - 2);
        }
        return new Rectangle((int)this.getButtonRect().getMaxX() + 2, 1, this.getWidth() - this.getButtonRect().width - 4, this.getHeight() - 2);
    }

    public Image getButtonImage() {
        return this.m_pButtonImage;
    }

    public void setButtonImage(Image value) {
        if (this.m_pButtonImage != value) {
            this.m_pButtonImage = value;
        }
    }

    protected void OnButtonClicked() {
    }
}

