/*
 * Decompiled with CFR 0.152.
 */
package LumiSoft.UI.Control.WGrid;

import LumiSoft.UI.Control.WGrid.Column;
import LumiSoft.UI.Control.WGrid.Columns;
import LumiSoft.UI.Control.WGrid.Row;
import LumiSoft.UI.Control.WGrid.WDragWindow;
import LumiSoft.UI.Control.WGrid.WGridControl;
import LumiSoft.UI.Control.WGrid.WScrollBar;
import LumiSoft.UI.Control.WGrid.WTextEditor;
import LumiSoft.UI.Controls.Paint;
import LumiSoft.UI.Controls.ViewStyle;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;

public class WGridTableView {
    private WGridControl m_pGrid = null;
    private WGridTableView m_pParentView = null;
    private Row m_pParentRow = null;
    private int m_FirstVisibleRow = 0;
    private Column m_pActiveColumn = null;
    private Row m_pActiveRow = null;
    private WScrollBar m_pVtScrollBar = null;
    private WScrollBar m_pHzScrollBar = null;
    private int m_PressedKeyCode = 0;
    private WDragWindow m_pDragWindow = null;
    private boolean m_Editable = false;
    private Columns m_pColumns = null;
    private Rectangle m_pBounds = null;
    private WTextEditor m_pActiveEditor = null;
    private Object m_pTag = null;
    private ArrayList m_pRowInfos = null;
    private ArrayList m_pRows = null;
    private ArrayList m_pSelectedRows = null;
    private Image m_pGraphicsBuffer = null;
    private int m_ColumnsStartX = 0;

    public WGridTableView(WGridControl grid) {
        this.m_pGrid = grid;
        this.m_pColumns = new Columns();
        this.m_pBounds = new Rectangle(-1, -1, 0, 0);
        this.m_pRowInfos = new ArrayList();
        this.m_pSelectedRows = new ArrayList();
        this.m_pVtScrollBar = new WScrollBar(grid, true);
        this.m_pHzScrollBar = new WScrollBar(grid, false);
        this.m_pRows = new ArrayList();
        this.m_pRows.add(new String[]{"row 1;col 1", "row 1;col 2", "row 1;col 3"});
        this.m_pRows.add(new String[]{"row 2;col 1", "row 2;col 2", "row 2;col 3"});
        this.m_pRows.add(new String[]{"row 3;col 1", "row 3;col 2", "row 3;col 3"});
        this.m_pRows.add(new String[]{"row 4;col 1", "row 4;col 2", "row 4;col 3"});
        this.m_pRows.add(new String[]{"row 5;col 1", "row 5;col 2", "row 5;col 3"});
        this.m_pRows.add(new String[]{"row 6;col 1", "row 6;col 2", "row 6;col 3"});
        this.m_pRows.add(new String[]{"row 7;col 1", "row 7;col 2", "row 7;col 3"});
        this.m_pRows.add(new String[]{"row 8;col 1", "row 8;col 2", "row 8;col 3"});
        this.m_pRows.add(new String[]{"row 9;col 1", "row 9;col 2", "row 9;col 3"});
        this.m_pRows.add(new String[]{"row 10;col 1", "row 10;col 2", "row 10;col 3"});
        int i = 0;
        while (i < this.m_pRows.size()) {
            this.m_pRowInfos.add(new Row(this.m_pRows.get(i)));
            ++i;
        }
    }

    protected void Paint(Graphics2D g2) {
        if (this.m_pGraphicsBuffer != null) {
            g2.drawImage(this.m_pGraphicsBuffer, this.getBounds().x, this.getBounds().y, this.m_pGrid);
            return;
        }
        this.m_pGraphicsBuffer = this.m_pGrid.createImage(this.getBounds().width, this.getBounds().height);
        Graphics2D g = (Graphics2D)this.m_pGraphicsBuffer.getGraphics();
        g.translate(-this.getBounds().x, -this.getBounds().y);
        g.setClip(g2.getClip());
        g.setColor(Color.WHITE);
        g.fill(this.getBounds());
        this.PaintHeader(g);
        this.PaintFoother(g);
        g.setClip(new Rectangle(this.getBounds().x, (int)this.getColumnsRect().getMaxY(), this.getBounds().width, this.getBounds().height - this.getColumnsRect().height - this.getFootherRect().height - this.m_pHzScrollBar.getBounds().height));
        int i = this.m_FirstVisibleRow;
        while (i < this.m_pRowInfos.size()) {
            Row rowInfo = (Row)this.m_pRowInfos.get(i);
            if ((double)rowInfo.getBounds().y > this.getRowsRect().getMaxY()) break;
            this.PaintRow(g, rowInfo);
            ++i;
        }
        g.setClip(this.getBounds());
        g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
        g.drawRect(this.getBounds().x, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height - 1);
        this.m_pVtScrollBar.Paint(g);
        this.m_pHzScrollBar.Paint(g);
        g.dispose();
        g2.drawImage(this.m_pGraphicsBuffer, this.getBounds().x, this.getBounds().y, this.m_pGrid);
    }

    public void Repaint() {
        this.Repaint(true);
    }

    public void Repaint(boolean paintFromBuffer) {
        if (!paintFromBuffer) {
            this.m_pGraphicsBuffer = null;
        }
        this.Paint((Graphics2D)this.m_pGrid.getGraphics());
    }

    private void PaintHeader(Graphics2D g) {
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fillRect(this.getBounds().x, this.getBounds().y, this.m_ColumnsStartX - this.getBounds().x, this.getColumnsRect().height);
        g.setClip(this.getColumnsRect());
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fill(this.getColumnsRect());
        g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
        g.draw(this.getColumnsRect());
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (col.getVisible() && col.getBounds().getMaxX() > -1.0 && (double)col.getBounds().x < this.getRowsRect().getMaxX()) {
                g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
                g.fillRect(col.getBounds().x, col.getBounds().y, col.getBounds().width, col.getBounds().height);
                g.setColor(Color.BLACK);
                Paint.DrawText(g, col.getFont(), col.getText(), col.getBounds(), 1);
                this.PaintRaisedBorder(g, new Rectangle(col.getBounds().x, col.getBounds().y, col.getBounds().width, col.getBounds().height));
            }
            ++i;
        }
        g.setClip(this.getBounds());
    }

    private void PaintFoother(Graphics2D g) {
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fill(this.getFootherRect());
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (col.getVisible() && col.getBounds().getMaxX() > -1.0 && (double)col.getBounds().x < this.getRowsRect().getMaxX() && col.getFootherText().length() > 0) {
                g.setColor(Color.BLACK);
                Paint.DrawText(g, col.getFont(), col.getFootherText(), new Rectangle(col.getBounds().x + 4, this.getFootherRect().y + 3, col.getBounds().width - 8, this.getFootherRect().height - 6), col.getFootherTextAlign());
                g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
                g.drawRect(col.getBounds().x + 2, this.getFootherRect().y + 2, col.getBounds().width - 4, this.getFootherRect().height - 6);
            }
            ++i;
        }
        this.PaintRaisedBorder(g, new Rectangle(this.getFootherRect().x, this.getFootherRect().y, this.getFootherRect().width - 1, this.getFootherRect().height - 1));
    }

    private void PaintRow(Graphics2D g, Row rowInfo) {
        boolean activeRow = this.m_pActiveRow != null && rowInfo.getRowSource().hashCode() == this.m_pActiveRow.getRowSource().hashCode();
        boolean selected = this.m_pSelectedRows.contains(rowInfo);
        boolean colX = false;
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (col.getVisible() && col.getBounds().getMaxX() > -1.0 && (double)col.getBounds().x < this.getRowsRect().getMaxX()) {
                boolean cellSelected = false;
                if (!selected || activeRow && this.m_pActiveColumn != null && col.equals(this.m_pActiveColumn)) {
                    int rowIndex = this.m_pRows.indexOf(rowInfo.getRowSource());
                    if ((double)rowIndex / 2.0 != Math.floor((double)rowIndex / 2.0)) {
                        g.setColor(ViewStyle.GetColorFromRgb(245, 245, 245));
                    } else {
                        g.setColor(Color.WHITE);
                    }
                    g.fillRect(col.getBounds().x, rowInfo.getY(), col.getBounds().width, rowInfo.getRowHeight());
                } else {
                    g.setColor(ViewStyle.GetColorFromRgb(64, 56, 181));
                    g.fillRect(col.getBounds().x, rowInfo.getY(), col.getBounds().width, rowInfo.getRowHeight());
                    cellSelected = true;
                }
                WTextEditor ed = new WTextEditor();
                ed.Paint(g, rowInfo.GetValue(i), new Rectangle(col.getBounds().x, rowInfo.getY(), col.getBounds().width, rowInfo.getRowHeight()), cellSelected);
                g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
                g.drawRect(col.getBounds().x, rowInfo.getY(), col.getBounds().width, rowInfo.getRowHeight());
            }
            ++i;
        }
        if (activeRow && this.m_pActiveColumn != null) {
            g.setColor(Color.BLACK);
            g.drawRect(this.m_pActiveColumn.getBounds().x + 1, rowInfo.getY() + 1, this.m_pActiveColumn.getBounds().width - 2, rowInfo.getRowHeight() - 2);
        }
        g.setColor(ViewStyle.GetColorFromRgb(212, 208, 200));
        g.fillRect(this.getBounds().x, rowInfo.getBounds().y, 20, rowInfo.getBounds().height);
        this.PaintRaisedBorder(g, new Rectangle(this.getBounds().x, rowInfo.getBounds().y, 20, rowInfo.getBounds().height));
        g.setColor(Color.WHITE);
        g.fillRect(this.getMasterDetailRect().x, rowInfo.getBounds().y, 20, rowInfo.getBounds().height);
        if (rowInfo.getDetailView() == null) {
            g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
            g.drawRect(this.getMasterDetailRect().x + 5, rowInfo.getBounds().y + 5, 10, 10);
            g.drawLine(this.getMasterDetailRect().x + 8, rowInfo.getBounds().y + 10, this.getMasterDetailRect().x + 12, rowInfo.getBounds().y + 10);
            g.drawLine(this.getMasterDetailRect().x + 10, rowInfo.getBounds().y + 8, this.getMasterDetailRect().x + 10, rowInfo.getBounds().y + 12);
        } else {
            g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
            g.drawRect(this.getMasterDetailRect().x + 5, rowInfo.getBounds().y + 5, 10, 10);
            g.drawLine(this.getMasterDetailRect().x + 8, rowInfo.getBounds().y + 10, this.getMasterDetailRect().x + 12, rowInfo.getBounds().y + 10);
        }
        this.PaintRaisedBorder(g, new Rectangle(this.getMasterDetailRect().x, rowInfo.getBounds().y, 20, rowInfo.getBounds().height));
        if (rowInfo.getDetailView() != null) {
            rowInfo.getDetailView().Paint(g);
        }
    }

    private void PaintRaisedBorder(Graphics2D g, Rectangle rect) {
        g.setColor(ViewStyle.GetColorFromRgb(128, 128, 128));
        g.draw(rect);
        g.setColor(Color.WHITE);
        g.drawLine(rect.x + 1, rect.y + 1, rect.x + rect.width - 2, rect.y + 1);
        g.drawLine(rect.x + 1, rect.y + 1, rect.x + 1, rect.y + rect.height - 2);
    }

    private void RepaintRow(Row rowInfo) {
        Graphics2D g;
        if (this.m_pGraphicsBuffer != null) {
            g = (Graphics2D)this.m_pGraphicsBuffer.getGraphics();
            g.translate(-this.getBounds().x, -this.getBounds().y);
            g.setClip(this.getRowsRect());
            this.PaintRow(g, rowInfo);
            g.dispose();
        }
        g = (Graphics2D)this.m_pGrid.getGraphics();
        g.setClip(this.getRowsRect());
        this.PaintRow(g, rowInfo);
    }

    protected void Process_keyTyped(KeyEvent e) {
    }

    protected void Process_keyPressed(KeyEvent e) {
        this.m_PressedKeyCode = e.getKeyCode();
    }

    protected void Process_keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.MoveNext();
        } else if (e.getKeyCode() == 40) {
            if (this.m_pActiveRow != null && this.m_pActiveRow.getDetailView() != null) {
                this.m_pActiveRow.getDetailView().SelectNextRow();
            } else if (this.m_pActiveRow != null && this.m_pParentView != null && this.m_pRowInfos.indexOf(this.m_pActiveRow) == this.m_pRowInfos.size() - 1) {
                this.m_pParentView.SelectRow(this.m_pParentRow, null, false);
                this.m_pParentView.SelectNextRow();
            } else {
                this.SelectNextRow();
            }
        } else if (e.getKeyCode() == 38) {
            if (this.m_pRowInfos.indexOf(this.m_pActiveRow) == 0 && this.m_pParentView != null && this.m_pParentRow != null) {
                this.m_pParentView.SelectRow(this.m_pParentRow, null, false);
            } else {
                this.SelectPreviousRow();
                if (this.m_pActiveRow != null && this.m_pActiveRow.getDetailView() != null) {
                    this.m_pActiveRow.getDetailView().SelectLastVisibleRow();
                }
            }
        } else if (e.getKeyCode() == 39) {
            if (this.m_pColumns.indexOf(this.m_pActiveColumn) < this.m_pColumns.size() - 1) {
                this.m_pActiveColumn = (Column)this.m_pColumns.get(this.m_pColumns.indexOf(this.m_pActiveColumn) + 1);
                this.RepaintRow(this.m_pActiveRow);
            }
        } else if (e.getKeyCode() == 37 && this.m_pColumns.indexOf(this.m_pActiveColumn) > 0) {
            this.m_pActiveColumn = (Column)this.m_pColumns.get(this.m_pColumns.indexOf(this.m_pActiveColumn) - 1);
            this.RepaintRow(this.m_pActiveRow);
        }
        this.m_PressedKeyCode = 0;
    }

    protected void Process_mousePressed(MouseEvent e) {
        boolean rowChanged;
        if (!this.m_pGrid.hasFocus()) {
            this.m_pGrid.grabFocus();
        }
        if (e.getPoint().x > this.getBounds().x + 20 && e.getPoint().x < this.getBounds().x + 40) {
            int i = this.m_FirstVisibleRow;
            while (i < this.m_pRowInfos.size()) {
                Row rowInfo = (Row)this.m_pRowInfos.get(i);
                if (e.getPoint().y > rowInfo.getBounds().y && (double)e.getPoint().y < rowInfo.getBounds().getMaxY()) {
                    this.SelectRow(rowInfo, this.m_pActiveColumn, true);
                    this.ToggleRow(rowInfo);
                    break;
                }
                ++i;
            }
            return;
        }
        Column mouseCol = this.GetColumnFromPoint(e.getPoint());
        int x = this.m_pGrid.getLocationOnScreen().x + e.getPoint().x;
        int y = this.m_pGrid.getLocationOnScreen().y + this.getColumnsRect().y;
        if (mouseCol != null && e.getPoint().getX() >= mouseCol.getBounds().getMaxX() - 3.0 && e.getPoint().getX() <= mouseCol.getBounds().getMaxX()) {
            this.m_pDragWindow = new WDragWindow(this.m_pGrid);
            this.m_pDragWindow.setTag(mouseCol);
            this.m_pDragWindow.Show(x, y, 1, this.getBounds().height - this.m_pHzScrollBar.getBounds().height, Color.BLACK);
            this.m_pGrid.m_pFocusedView = this;
            return;
        }
        if (this.m_pVtScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pVtScrollBar.Process_mousePressed(e);
            return;
        }
        if (this.m_pHzScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pHzScrollBar.Process_mousePressed(e);
            return;
        }
        if (!this.getRowsRect().contains(e.getPoint())) {
            return;
        }
        Row hittedRow = this.GetRowFromPoint(e.getPoint());
        Column hittedCellColumn = null;
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (e.getPoint().x > col.getBounds().x && (double)e.getPoint().x < col.getBounds().getMaxX()) {
                hittedCellColumn = col;
            }
            ++i;
        }
        if (e.isShiftDown()) {
            if (this.m_pActiveRow != null) {
                this.SelectRows(this.m_pActiveRow, hittedRow);
            } else {
                this.SelectRows(hittedRow, hittedRow);
            }
            this.Repaint(false);
            return;
        }
        if (hittedRow != null && e.isControlDown()) {
            this.ToggleRowSelection(hittedRow);
            this.RepaintRow(hittedRow);
            return;
        }
        boolean bl = rowChanged = hittedRow != this.m_pActiveRow;
        if (hittedRow != null && (this.m_pActiveColumn != hittedCellColumn || rowChanged)) {
            if (hittedCellColumn != null) {
                this.ShowEditor(hittedCellColumn);
            }
            this.SelectRow(hittedRow, hittedCellColumn, true);
        }
        this.m_pGrid.m_pFocusedView = this;
    }

    protected void Process_mouseReleased(MouseEvent e) {
        if (this.m_pDragWindow != null) {
            Column col = (Column)this.m_pDragWindow.getTag();
            int x = this.m_pGrid.getLocationOnScreen().x + e.getPoint().x;
            int colX = this.m_pGrid.getLocationOnScreen().x + col.getBounds().x;
            int width = x - colX;
            if (width > 0) {
                col.setWidth(width);
                this.Calculate();
                this.Repaint();
            }
            this.m_pDragWindow.dispose();
            this.m_pDragWindow = null;
            return;
        }
        if (this.m_pVtScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pVtScrollBar.Process_mouseReleased(e);
        }
        if (this.m_pHzScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pHzScrollBar.Process_mouseReleased(e);
        }
    }

    protected void Process_mouseEntered(MouseEvent e) {
    }

    protected void Process_mouseExited(MouseEvent e) {
        this.m_pVtScrollBar.Process_mouseExited(e);
    }

    protected void Process_mouseWheelMoved(MouseWheelEvent e) {
        if (this.m_PressedKeyCode == 16) {
            if (e.getUnitsToScroll() < 0) {
                if (this.m_pHzScrollBar.getPosition() > this.m_pHzScrollBar.getMinimum()) {
                    this.m_pHzScrollBar.setPosition(this.m_pHzScrollBar.getPosition() - 5);
                    this.Calculate();
                    this.Repaint();
                }
            } else if (this.m_pHzScrollBar.getPosition() < this.m_pHzScrollBar.getMaximum()) {
                this.m_pHzScrollBar.setPosition(this.m_pHzScrollBar.getPosition() + 5);
                this.Calculate();
                this.Repaint();
            }
        } else if (e.getUnitsToScroll() < 0) {
            if (this.m_pVtScrollBar.getPosition() > this.m_pVtScrollBar.getMinimum()) {
                this.m_pVtScrollBar.setPosition(this.m_pVtScrollBar.getPosition() - 1);
                this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
                this.Calculate();
                this.Repaint();
            }
        } else if (this.m_pVtScrollBar.getPosition() < this.m_pVtScrollBar.getMaximum()) {
            this.m_pVtScrollBar.setPosition(this.m_pVtScrollBar.getPosition() + 1);
            this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
            this.Calculate();
            this.Repaint();
        }
    }

    protected void Process_mouseMoved(MouseEvent e) {
        if (this.m_pDragWindow != null) {
            return;
        }
        if (this.m_pVtScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pVtScrollBar.Process_mouseMoved(e);
        } else if (this.m_pVtScrollBar.IsMouseActive()) {
            this.m_pVtScrollBar.Process_mouseExited(null);
        }
        if (this.m_pHzScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pHzScrollBar.Process_mouseMoved(e);
        } else if (this.m_pHzScrollBar.IsMouseActive()) {
            this.m_pHzScrollBar.Process_mouseExited(null);
        }
        this.m_pGrid.setCursor(Cursor.getPredefinedCursor(0));
        int x = this.m_pGrid.getLocationOnScreen().x + e.getPoint().x;
        int y = this.m_pGrid.getLocationOnScreen().y + this.getColumnsRect().y;
        Column mouseCol = this.GetColumnFromPoint(e.getPoint());
        if (mouseCol != null && e.getPoint().getX() >= mouseCol.getBounds().getMaxX() - 3.0 && e.getPoint().getX() <= mouseCol.getBounds().getMaxX()) {
            this.m_pGrid.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    protected void Process_mouseClicked(MouseEvent e) {
        if (this.m_pVtScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pVtScrollBar.Process_mouseClicked(e);
            this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
            this.Calculate();
            this.Repaint();
        } else if (this.m_pHzScrollBar.getBounds().contains(e.getPoint())) {
            this.m_pHzScrollBar.Process_mouseClicked(e);
            this.Calculate();
            this.Repaint();
        }
    }

    protected void Process_mouseDragged(MouseEvent e) {
        if (this.m_pDragWindow != null) {
            this.m_pDragWindow.UpdatePosition(this.m_pGrid.getLocationOnScreen().x + e.getPoint().x, this.m_pGrid.getLocationOnScreen().y + this.getColumnsRect().y);
        }
    }

    private void Calculate() {
        this.m_pGraphicsBuffer = null;
        if (this.m_pActiveRow != null) {
            this.m_pActiveRow.Hide();
        }
        int colsHeight = this.CalculateColumnsHeight();
        this.m_ColumnsStartX = this.getBounds().x + 20 + 20;
        int colsWidth = 0;
        int colX = this.m_ColumnsStartX;
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (col.getVisible()) {
                col.setBounds(new Rectangle(colX - this.m_pHzScrollBar.getPosition(), this.getBounds().y, col.getWidth(), colsHeight));
                colsWidth += col.getWidth();
                colX += col.getWidth();
            }
            ++i;
        }
        int rowY = this.getBounds().y + colsHeight;
        int i2 = 0;
        while (i2 < this.m_pRowInfos.size()) {
            Row rowInfo = (Row)this.m_pRowInfos.get(i2);
            if (i2 >= this.m_FirstVisibleRow) {
                if ((double)rowY > this.getRowsRect().getMaxY()) {
                    rowInfo.Hide();
                } else {
                    rowInfo.setRowHeight(this.CalculateRowHeight(rowInfo));
                    rowInfo.setBounds(new Rectangle(this.m_ColumnsStartX, rowY, colX - this.m_ColumnsStartX, this.CalculateRowHeight(rowInfo)));
                    if (rowInfo.getDetailView() != null) {
                        int maxSize = (int)this.getRowsRect().getMaxY() - (int)rowInfo.getBounds().getY() - rowInfo.getRowHeight();
                        rowInfo.getDetailView().setBounds(new Rectangle(rowInfo.getBounds().x, rowInfo.getBounds().y + rowInfo.getRowHeight(), this.getBounds().width - this.m_pVtScrollBar.getBounds().width - 40, maxSize));
                        rowInfo.getDetailView().AutoSize();
                        rowInfo.setBounds(new Rectangle(rowInfo.getBounds().x, rowInfo.getBounds().y, rowInfo.getBounds().width, rowInfo.getRowHeight() + rowInfo.getDetailView().getBounds().height));
                    }
                }
            } else {
                rowInfo.Hide();
            }
            rowY += rowInfo.getBounds().height;
            ++i2;
        }
        if (this.m_FirstVisibleRow == 0 && (double)rowY < this.getRowsRect().getMaxY()) {
            this.m_pVtScrollBar.setBounds(new Rectangle(-1, -1, 0, 0));
        } else {
            this.m_pVtScrollBar.setBounds(new Rectangle((int)this.getBounds().getMaxX() - 20, this.getBounds().y, 20, this.getBounds().height));
            this.m_pVtScrollBar.setMaximum(9);
        }
        if (colsWidth < this.getRowsRect().width) {
            this.m_pHzScrollBar.setBounds(new Rectangle(-1, -1, 0, 0));
        } else {
            this.m_pHzScrollBar.setBounds(new Rectangle(this.getBounds().x, (int)this.getBounds().getMaxY() - 18, this.getBounds().width - 20, 17));
            this.m_pHzScrollBar.setMaximum(colsWidth - this.getRowsRect().width + 20);
        }
    }

    protected void AutoSize() {
        Row rowInfo = (Row)this.m_pRowInfos.get(this.m_pRowInfos.size() - 1);
        if (this.m_FirstVisibleRow == 0 && rowInfo.getBounds().y > -1 && rowInfo.getBounds().getMaxY() < this.getRowsRect().getMaxY()) {
            int size = (int)this.getRowsRect().getMaxY() - (int)rowInfo.getBounds().getY() - rowInfo.getRowHeight();
            this.setBounds(new Rectangle(this.m_pBounds.x, this.m_pBounds.y, this.m_pBounds.width, this.m_pBounds.height - size));
        }
    }

    private int CalculateColumnsHeight() {
        return 20;
    }

    private int CalculateRowHeight(Row rowInfo) {
        return 19;
    }

    protected void UnSelect() {
        if (this.m_pActiveRow != null) {
            Row activeRow = this.m_pActiveRow;
            this.m_pActiveRow = null;
            this.RepaintRow(activeRow);
        }
        ArrayList selectedRows = (ArrayList)this.m_pSelectedRows.clone();
        this.m_pSelectedRows.clear();
        int i = 0;
        while (i < selectedRows.size()) {
            Row row = (Row)selectedRows.get(i);
            this.RepaintRow(row);
            ++i;
        }
    }

    private void SelectRow(Row rowInfo, Column col, boolean clearSelection) {
        if (this.m_pActiveRow == rowInfo && this.m_pActiveColumn == col) {
            return;
        }
        if (this.m_pGrid.m_pFocusedView != null && !this.m_pGrid.m_pFocusedView.equals(this)) {
            this.m_pGrid.m_pFocusedView.UnSelect();
        }
        if (clearSelection) {
            ArrayList selectedRows = (ArrayList)this.m_pSelectedRows.clone();
            this.m_pSelectedRows.clear();
            int i = 0;
            while (i < selectedRows.size()) {
                Row row = (Row)selectedRows.get(i);
                this.RepaintRow(row);
                ++i;
            }
        }
        if (this.m_pActiveRow != null && this.m_pActiveRow.getBounds().x > -1) {
            Row oldRow = this.m_pActiveRow;
            this.m_pActiveRow = null;
            this.RepaintRow(oldRow);
        }
        if (col != null) {
            this.m_pActiveColumn = col;
        }
        this.m_pGrid.m_pFocusedView = this;
        this.m_pActiveRow = rowInfo;
        this.m_pSelectedRows.add(this.m_pActiveRow);
        if (this.getRowsRect().getMaxY() < this.m_pActiveRow.getBounds().getMaxY()) {
            while (this.getRowsRect().getMaxY() < this.m_pActiveRow.getBounds().getMaxY()) {
                this.m_pVtScrollBar.setPosition(this.m_pVtScrollBar.getPosition() + 1);
                this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
                this.Calculate();
            }
            this.Repaint();
        } else {
            this.RepaintRow(this.m_pActiveRow);
        }
    }

    private void SelectFirstVisibleRow() {
        this.SelectRow((Row)this.m_pRowInfos.get(this.m_FirstVisibleRow), this.m_pActiveColumn, true);
    }

    private void SelectLastVisibleRow() {
        Row lastVisbleRow = null;
        int i = this.m_FirstVisibleRow;
        while (i < this.m_pRowInfos.size()) {
            Row rowInfo = (Row)this.m_pRowInfos.get(i);
            if (!(rowInfo.getRowBounds().getMaxY() <= this.getRowsRect().getMaxY())) break;
            lastVisbleRow = rowInfo;
            ++i;
        }
        this.SelectRow(lastVisbleRow, this.m_pActiveColumn, true);
    }

    private void SelectNextRow() {
        if (this.m_pRowInfos.indexOf(this.m_pActiveRow) < this.m_pRowInfos.size() - 1) {
            Row rowInfo = (Row)this.m_pRowInfos.get(this.m_pRowInfos.indexOf(this.m_pActiveRow) + 1);
            if (rowInfo.getBounds().x > -1) {
                this.SelectRow(rowInfo, this.m_pActiveColumn, true);
            } else {
                this.m_pVtScrollBar.setPosition(this.m_pVtScrollBar.getPosition() + 1);
                this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
                this.SelectRow(rowInfo, this.m_pActiveColumn, true);
                this.Calculate();
                this.Repaint();
            }
        }
    }

    private void SelectPreviousRow() {
        if (this.m_pRowInfos.indexOf(this.m_pActiveRow) > 0 && this.m_pRowInfos.indexOf(this.m_pActiveRow) > this.m_FirstVisibleRow) {
            this.SelectRow((Row)this.m_pRowInfos.get(this.m_pRowInfos.indexOf(this.m_pActiveRow) - 1), this.m_pActiveColumn, true);
        } else if (this.m_FirstVisibleRow > 0) {
            this.m_pVtScrollBar.setPosition(this.m_pVtScrollBar.getPosition() - 1);
            this.m_FirstVisibleRow = this.m_pVtScrollBar.getPosition();
            this.SelectRow((Row)this.m_pRowInfos.get(this.m_FirstVisibleRow), this.m_pActiveColumn, true);
            this.Calculate();
            this.Repaint();
        }
    }

    private void SelectRows(Row startRow, Row endRow) {
        this.m_pSelectedRows.clear();
        if (this.m_pRowInfos.indexOf(startRow) == this.m_pRowInfos.indexOf(endRow)) {
            this.m_pSelectedRows.add(startRow);
        }
        if (this.m_pRowInfos.indexOf(startRow) < this.m_pRowInfos.indexOf(endRow)) {
            int i = this.m_pRowInfos.indexOf(startRow);
            while (i <= this.m_pRowInfos.indexOf(endRow)) {
                this.m_pSelectedRows.add((Row)this.m_pRowInfos.get(i));
                ++i;
            }
        } else {
            int i = this.m_pRowInfos.indexOf(endRow);
            while (i <= this.m_pRowInfos.indexOf(startRow)) {
                this.m_pSelectedRows.add((Row)this.m_pRowInfos.get(i));
                ++i;
            }
        }
        this.SelectRow(endRow, this.m_pActiveColumn, false);
    }

    private boolean ToggleRowSelection(Row rowInfo) {
        if (this.m_pSelectedRows.contains(rowInfo)) {
            this.m_pSelectedRows.remove(rowInfo);
            if (rowInfo.equals(this.m_pActiveRow)) {
                this.m_pActiveRow = null;
            }
            return false;
        }
        this.SelectRow(rowInfo, this.m_pActiveColumn, false);
        return true;
    }

    private Column GetColumnFromPoint(Point pt) {
        int i = 0;
        while (i < this.m_pColumns.size()) {
            Column col = (Column)this.m_pColumns.get(i);
            if (col.getVisible() && col.getBounds().contains(pt)) {
                return col;
            }
            ++i;
        }
        return null;
    }

    private Row GetRowFromPoint(Point pt) {
        int i = this.m_FirstVisibleRow;
        while (i < this.m_pRowInfos.size()) {
            Row rowInfo = (Row)this.m_pRowInfos.get(i);
            if ((double)rowInfo.getBounds().y > this.getRowsRect().getMaxY()) break;
            if (rowInfo.getBounds().contains(pt)) {
                return rowInfo;
            }
            ++i;
        }
        return null;
    }

    private void HideEditor() {
        if (this.m_pActiveEditor != null) {
            this.m_pGrid.remove(this.m_pActiveEditor);
            this.m_pActiveEditor = null;
        }
    }

    private void ShowEditor(Column col) {
        if (col.getVisible() && this.m_Editable) {
            this.m_pActiveEditor = new WTextEditor();
            this.m_pActiveEditor.setBounds(col.getBounds().x + 4, this.m_pActiveRow.getY() + 1, col.getBounds().width - 6, col.getBounds().height - 1);
            this.m_pActiveEditor.m_pRow = this.m_pActiveRow;
            this.m_pGrid.add(this.m_pActiveEditor);
            this.m_pActiveEditor.repaint();
        }
    }

    private boolean MayChangeRow() {
        return true;
    }

    private Rectangle getRowIndicatorRect() {
        return new Rectangle(this.getBounds().x, this.getBounds().y, 20, this.getBounds().height);
    }

    private Rectangle getMasterDetailRect() {
        return new Rectangle(this.getBounds().x + 20, this.getBounds().y, 20, this.getBounds().height);
    }

    private Rectangle getColumnsRect() {
        Column lastVisibleCol = (Column)this.m_pColumns.get(this.m_pColumns.size() - 1);
        if (this.getBounds().getMaxX() - (double)this.m_pVtScrollBar.getBounds().width > lastVisibleCol.getBounds().getMaxX()) {
            return new Rectangle(this.m_ColumnsStartX, this.getBounds().y, (int)lastVisibleCol.getBounds().getMaxX() - this.m_ColumnsStartX + 1, 20);
        }
        return new Rectangle(this.m_ColumnsStartX, this.getBounds().y, this.getBounds().width - this.m_pVtScrollBar.getBounds().width, 20);
    }

    private Rectangle getFootherRect() {
        Column lastVisibleCol = (Column)this.m_pColumns.get(this.m_pColumns.size() - 1);
        if (this.getBounds().getMaxX() - (double)this.m_pVtScrollBar.getBounds().width > lastVisibleCol.getBounds().getMaxX()) {
            return new Rectangle(this.getBounds().x, (int)this.getBounds().getMaxY() - 20 - this.m_pHzScrollBar.getBounds().height, (int)lastVisibleCol.getBounds().getMaxX() - this.getBounds().x + 1, 20);
        }
        return new Rectangle(this.getBounds().x, (int)this.getBounds().getMaxY() - 20 - this.m_pHzScrollBar.getBounds().height, this.getBounds().width - this.m_pVtScrollBar.getBounds().width, 20);
    }

    private Rectangle getRowsRect() {
        Rectangle colsRect = this.getColumnsRect();
        return new Rectangle(this.m_ColumnsStartX, (int)colsRect.getMaxY(), this.getBounds().width - this.getMasterDetailRect().width - this.m_pVtScrollBar.getBounds().width - 21, this.getFootherRect().y - (int)this.getColumnsRect().getMaxY());
    }

    public void MoveNext() {
        if (this.m_pActiveColumn != null) {
            if (this.m_pColumns.indexOf(this.m_pActiveColumn) < this.m_pColumns.size() - 1) {
                this.m_pActiveColumn = (Column)this.m_pColumns.get(this.m_pColumns.indexOf(this.m_pActiveColumn) + 1);
            } else {
                this.m_pActiveColumn = (Column)this.m_pColumns.get(0);
                this.SelectNextRow();
            }
            this.Repaint();
        }
    }

    public void ExpandRow(Row rowInfo) {
        if (rowInfo.getDetailView() == null) {
            WGridTableView detailView = new WGridTableView(this.m_pGrid);
            detailView.m_pParentView = this;
            detailView.m_pParentRow = rowInfo;
            detailView.getCloumns().AddColumn("Col 1", 70);
            detailView.getCloumns().AddColumn("Col 2", 70);
            this.m_pGrid.m_pActiveViews.add(detailView);
            rowInfo.setDetailView(detailView);
            this.Calculate();
            this.Repaint();
        }
    }

    public void CollapseRow(Row rowInfo) {
        if (rowInfo.getDetailView() != null) {
            this.m_pGrid.m_pFocusedView = this;
            this.m_pGrid.m_pActiveViews.remove(rowInfo.getDetailView());
            rowInfo.setDetailView(null);
            rowInfo.setBounds(new Rectangle(rowInfo.getBounds().x, rowInfo.getBounds().y, rowInfo.getBounds().width, rowInfo.getRowHeight()));
            this.Calculate();
            this.Repaint();
        }
    }

    public void ToggleRow(Row rowInfo) {
        if (rowInfo.getDetailView() == null) {
            this.ExpandRow(rowInfo);
        } else {
            this.CollapseRow(rowInfo);
        }
    }

    public boolean getEditable() {
        return this.m_Editable;
    }

    public void setEditable(boolean value) {
        if (this.m_Editable != value) {
            this.m_Editable = value;
        }
    }

    public Columns getCloumns() {
        return this.m_pColumns;
    }

    public Rectangle getBounds() {
        return this.m_pBounds;
    }

    protected void setBounds(Rectangle value) {
        if (!this.m_pBounds.equals(value)) {
            this.m_pBounds = value;
            this.Calculate();
        }
    }

    public WTextEditor getActiveEditor() {
        return this.m_pActiveEditor;
    }

    public Object getTag() {
        return this.m_pTag;
    }

    protected void setTag(Object value) {
        if (this.m_pTag != value) {
            this.m_pTag = value;
        }
    }
}

